<?php
/* @var $interiorId int */
/* @var $kampania Kampanie */
/* @var $loga array */
/* @var $kampanie array */
?>

<style type="text/css">
div.intARxrPricing tr > td {text-align:center}
.intARxrPricing .bought {background:rgba(0,255,0,0.3)}
.intARxrPricing table thead td {font-weight:bold;border-bottom:1px solid black}
.intARxrPricing table {height:calc(100% - 25px)}
.intARxrImages img
{
	max-width: 130px;
	max-height: 130px;
	margin: 0;
	padding: 15px;
	display: inline-block;
	cursor: pointer;
	opacity: 0.6;
}
.intARxrImages img.selected
{
	opacity: 1;
}
.intARxrImages img:hover
{
	opacity: 1;
}
.intARxrImages {
	background: rgba(255, 255, 255, 0.7);
}
.intARxrPricing .disabled, .intARxrPricing .buyDisabled {
	pointer-events: none;
	cursor: default;
	color: gray;
}
</style>

<script type="text/javascript">
(function()
{
	var LOGA = <?php echo json_encode($loga); ?>;
	var HAS_LOGO = <?php echo json_encode(!empty(Yii::app()->user->logo_firmy)); ?>;
	var CENA = <?php echo number_format($kampania->cenaDzien, 2, '.', ' '); ?>;
	var VAT = <?php echo number_format($vat, 2, '.', ' '); ?>;
	var MAX_DISCOUNT = <?php echo json_encode($maxDiscount); ?>;
	var AGENCJA_ID = <?php echo json_encode($interiorId); ?>;
	var KAMPANIE = <?php echo json_encode($kampanie); ?>;
	var KAMPANIEen = <?php echo json_encode($kampanieEn); ?>;

	function dispatchEventHandlers()
	{
		$('.intARxrImages, .intARxrPricing, .intARdialog, .dontShowClose').each(function(){
			if ($(this).hasClass('ui-dialog-content'))
				$(this).dialog('close');
		});
		$(document).off('logaFiz.przedsiebiorcaDialogueEvents');
		$(document).off('logaMat.przedsiebiorcaDialogueEvents');
		$(document).off('logaBiol.przedsiebiorcaDialogueEvents');
		$(document).off('logaChem.przedsiebiorcaDialogueEvents');

		$(document).off('logaChemEn.przedsiebiorcaDialogueEvents');
		$(document).off('logaBiolEn.przedsiebiorcaDialogueEvents');
		$(document).off('logaMatEn.przedsiebiorcaDialogueEvents');
		$(document).off('logaFizEn.przedsiebiorcaDialogueEvents');

		$(document).off('cennikEn.przedsiebiorcaDialogueEvents');
		$(document).off('negotiatePriceEn.przedsiebiorcaDialogueEvents');
		$(document).off('buyDiscountCampaingEn.przedsiebiorcaDialogueEvents');
		$(document).off('buyCampaingEn.przedsiebiorcaDialogueEvents');

		$(document).off('cennik.przedsiebiorcaDialogueEvents');
		$(document).off('negotiatePrice.przedsiebiorcaDialogueEvents');
		$(document).off('buyDiscountCampaing.przedsiebiorcaDialogueEvents');
		$(document).off('buyCampaing.przedsiebiorcaDialogueEvents');
		$(document).off('getDialogueParam.przedsiebiorcaDialogueEvents');
	}
	dispatchEventHandlers();

	$(window).on('hashchange.przedsiebiorcaDialogueEvents', function(){
		dispatchEventHandlers();
		$(window).off('hashchange.przedsiebiorcaDialogueEvents');
	});

	function enableBts(enable)
	{
		var objs = $('.buy, .logoBuy, .ui-dialog-titlebar-close, input[type="button"], button');
		if (enable)
			objs.removeClass('disabled');
		else
			objs.addClass('disabled');
	}

	/// === LOGA =================================================================

	function browseLogosEn(dziedzina)
	{
		var html = '<div class="intARxrImages">';
		for (var i in LOGA[dziedzina])
		{
			var logoUrl = LOGA[dziedzina][i];
			html += '<img class="logoBuy" title="' + dziedzina + ' - ' + i + '" alt="' +
				dziedzina + ' - ' + i + '" file-id="' + i + '" src="' + logoUrl + '"/>';
		}
		html += '</div>';

		$(html).dialog({
			title: dziedzina + ' - Loga',
			modal: true,
			autoOpen: true,
			closeOnEscape: false,
			hide: { effect: 'clip', duration: 500 },
			show: { effect: 'scale', duration: 600 },
			open: function() {
				var _dlg = $(this);
				$('.logoBuy').click(function(){
					function clean(){
						$('.logoBuy, .ui-dialog-titlebar-close').removeClass('disabled');
						$('.logoBuy').removeClass('selected');
					}
					$('.logoBuy, .ui-dialog-titlebar-close').addClass('disabled');
					$(this).removeClass('disabled');
					$(this).addClass('selected');
					var key = $(this).attr('file-id');
					var src = $(this).attr('src');
					var q = HAS_LOGO ? (
						'Do you want to change logo: <img style="padding:5px;margin:auto;' +
						'max-width:130px;max-height:100px;display:block" src="' + window.userdata.logo_firmy +
						'"/>to new one: <img style="padding:5px;margin:auto;max-width:130px;' +
						'max-height:100px;display:block" src="' + src + '"/><br/>The cost is ' + (parseFloat(CENA)+parseFloat(VAT)*parseFloat(CENA)).toFixed(2) + ' PLN.'
					) : (
						'Are you sure you want to purchase this logo?<img style="' +
						'padding:5px;margin:auto;max-width:130px;max-height:130px;display:block" src="' + src
							+ '"/>The cost is ' + (parseFloat(CENA)+parseFloat(VAT)*parseFloat(CENA)).toFixed(2) + ' PLN.'
					);
					if (askEn('Choose logo', q, function(){
						$.ajax({
							type: 'POST',
							url: window.links.studentAjaxAdAgencyBuyLogo,
							data: {
								logo: key,
								dziedzina: dziedzina,
								agencyId: AGENCJA_ID
							},
							success: function(data) {
								if (data.error)
									showMessage('Błąd', data.error, {close: function(){
										if (data.bankrut)
											bankrutDialogOpen(true);
									}});
								else {
									var msg = 'New logo purchased! See the invoice ' +
										'<a target="_blank" href="<?php echo Yii::app()->createAbsoluteUrl('/student/main/invoice', array('id'=>'')) ?>/'
										+ data.invoice + '">here</a>.';
									showMessage('New logo purchased!', msg, {close: function(){
										Dialogue.current.gotoRoot();
										if (data.bankrut)
											bankrutDialogOpen(true);
									}});
									_dlg.dialog('close');
									window.userdata.logo_firmy = src;
									$('#symbol-firma img').fadeOut(400, function(){
										$('#symbol-firma img').attr('src', window.userdata.logo_firmy);
										$('#symbol-firma img').fadeIn();
									});
									HAS_LOGO = true;
								}
							},
							complete: clean
						});
					}, clean, 'intARdialog'));
				});
			},
			close: function() {
				$(this).parent().remove();
				//window.location.hash = "agencjaReklamowa"+AGENCJA_ID;
			},
			position: {
				my: "center",
				at: "center",
				of: window
			},
			draggable: true,
			resizable: false,
			width: 850,
			height: 385
		});
	}

	function browseLogos(dziedzina)
	{
		var html = '<div class="intARxrImages">';
		for (var i in LOGA[dziedzina])
		{
			var logoUrl = LOGA[dziedzina][i];
			html += '<img class="logoBuy" title="' + dziedzina + ' - ' + i + '" alt="' +
				dziedzina + ' - ' + i + '" file-id="' + i + '" src="' + logoUrl + '"/>';
		}
		html += '</div>';

		$(html).dialog({
			title: dziedzina + ' - Loga',
			modal: true,
			autoOpen: true,
			closeOnEscape: false,
			hide: { effect: 'clip', duration: 500 },
			show: { effect: 'scale', duration: 600 },
			open: function() {
				var _dlg = $(this);
				$('.logoBuy').click(function(){
					function clean(){
						$('.logoBuy, .ui-dialog-titlebar-close').removeClass('disabled');
						$('.logoBuy').removeClass('selected');
					}
					$('.logoBuy, .ui-dialog-titlebar-close').addClass('disabled');
					$(this).removeClass('disabled');
					$(this).addClass('selected');
					var key = $(this).attr('file-id');
					var src = $(this).attr('src');
					var q = HAS_LOGO ? (
						'Czy chesz wymienić logo: <img style="padding:5px;margin:auto;' +
						'max-width:130px;max-height:100px;display:block" src="' + window.userdata.logo_firmy +
						'"/>na następujące: <img style="padding:5px;margin:auto;max-width:130px;' +
						'max-height:100px;display:block" src="' + src + '"/><br/>Koszt usługi to ' + (parseFloat(CENA)+parseFloat(VAT)*parseFloat(CENA)).toFixed(2) + ' zł.'
					) : (
						'Czy jesteś pewien(a), że chcesz wybrać własnie to logo?<img style="' +
						'padding:5px;margin:auto;max-width:130px;max-height:130px;display:block" src="' + src
							+ '"/>Koszt usługi to ' + (parseFloat(CENA)+parseFloat(VAT)*parseFloat(CENA)).toFixed(2) + ' zł.'
					);
					if (ask('Wybór loga', q, function(){
						$.ajax({
							type: 'POST',
							url: window.links.studentAjaxAdAgencyBuyLogo,
							data: {
								logo: key,
								dziedzina: dziedzina,
								agencyId: AGENCJA_ID
							},
							success: function(data) {
								if (data.error)
									showMessage('Błąd', data.error, {close: function(){
										if (data.bankrut)
											bankrutDialogOpen(true);
									}});
								else {
									var msg = 'Zakupiono logo. Fakturę możesz podejrzeć ' +
										'<a target="_blank" href="<?php echo Yii::app()->createAbsoluteUrl('/student/main/invoice', array('id'=>'')) ?>/'
										+ data.invoice + '">tutaj</a>.';
									showMessage('Zakupiono logo', msg, {close: function(){
										Dialogue.current.gotoRoot();
										if (data.bankrut)
											bankrutDialogOpen(true);
									}});
									_dlg.dialog('close');
									window.userdata.logo_firmy = src;
									$('#symbol-firma img').fadeOut(400, function(){
										$('#symbol-firma img').attr('src', window.userdata.logo_firmy);
										$('#symbol-firma img').fadeIn();
									});
									HAS_LOGO = true;
								}
							},
							complete: clean
						});
					}, clean, 'intARdialog'));
				});
			},
			close: function() {
				$(this).parent().remove();
				//window.location.hash = "agencjaReklamowa"+AGENCJA_ID;
			},
			position: {
				my: "center",
				at: "center",
				of: window
			},
			draggable: true,
			resizable: false,
			width: 850,
			height: 385
		});
	}

	$(document).on('logaChem.przedsiebiorcaDialogueEvents', function(){
		browseLogos('Chemia');
	});
	$(document).on('logaBiol.przedsiebiorcaDialogueEvents', function(){
		browseLogos('Biologia');
	});
	$(document).on('logaMat.przedsiebiorcaDialogueEvents', function(){
		browseLogos('Matematyka');
	});
	$(document).on('logaFiz.przedsiebiorcaDialogueEvents', function(){
		browseLogos('Fizyka');
	});
	
	$(document).on('logaChemEn.przedsiebiorcaDialogueEvents', function(){
		browseLogosEn('Chemia');
	});
	$(document).on('logaBiolEn.przedsiebiorcaDialogueEvents', function(){
		browseLogosEn('Biologia');
	});
	$(document).on('logaMatEn.przedsiebiorcaDialogueEvents', function(){
		browseLogosEn('Matematyka');
	});
	$(document).on('logaFizEn.przedsiebiorcaDialogueEvents', function(){
		browseLogosEn('Fizyka');
	});

	/// === CENNIK ===============================================================

	function printDate(ts)
	{
		var date = new Date(ts*1000);
		var dd = date.getDate();
		if (dd < 10) dd = '0' + dd.toString();
		var mm = date.getMonth()+1;
		if (mm < 10) mm = '0' + mm.toString();
		return date.getFullYear().toString() + '-' + mm + '-' + dd;
	}

	var Campaing = {
		campaingId: 0,
		period: 0,
		discount: 0,
		price: 0
	};

	// ------

	function buyCampaing()
	{
		$('<div class="dontShowClose"><table style="width::100%;height:calc(100% - 25px)"><tr><td class="msg" style="text-align:center;'
			+ 'vertical-align:middle;font-weight:bold">Proszę czekać</td></tr></table></div>').dialog(
		{
			title: 'Zakup kampanii', dialogClass: 'dontShowClose',
			modal: true, autoOpen: true, closeOnEscape: false,
			show: { effect: 'fold', duration: 1000 },
			hide: { effect: 'explode', duration: 1000 },
			open: function() {
				var _dlg = $(this);
				enableBts(false);
				$.ajax({
					type: 'POST',
					url: window.links.studentAjaxBuyCampaing,
					data: Campaing,
					success: function(data) {
						if (data.error)
							_dlg.find('.msg').text(data.error);
						else {
							for (var i in KAMPANIE) {
								var kampania = KAMPANIE[i];
								if (kampania.id == Campaing.campaingId) {
									kampania.czasRozpoczecia = parseInt(data.czasRozpoczecia);
									kampania.czasZakonczenia = parseInt(data.czasZakonczenia);
									break;
								}
							}
							_dlg.find('.msg').html('Zakupiono kampanię. Fakturę możesz podejrzeć ' +
								'<a target="_blank" href="<?php echo Yii::app()->createAbsoluteUrl('/student/main/invoice', array('id'=>'')) ?>/'
								+ data.invoice + '">tutaj</a>.');
						}
						if (data.bankrut)
							bankrutDialogOpen(true);
					},
					complete: enableBts
				});
			},
			buttons: [{text:'OK',click:function(){ $(this).dialog('close'); }}],
			close: function() 
			{
				$(this).parent().remove(); 
				window.location.hash = "agencjaReklamowa"+AGENCJA_ID;
			},
			position: { my: 'center', at: 'center', of: window },
			draggable: true, resizable: false,
			width: 480, height: 320
		});
	}

	// ------

	function buyCampaingEn()
	{
		$('<div class="dontShowClose"><table style="width::100%;height:calc(100% - 25px)"><tr><td class="msg" style="text-align:center;'
			+ 'vertical-align:middle;font-weight:bold">Please wait</td></tr></table></div>').dialog(
		{
			title: 'Campaign purchase', dialogClass: 'dontShowClose',
			modal: true, autoOpen: true, closeOnEscape: false,
			show: { effect: 'fold', duration: 1000 },
			hide: { effect: 'explode', duration: 1000 },
			open: function() {
				var _dlg = $(this);
				enableBts(false);
				$.ajax({
					type: 'POST',
					url: window.links.studentAjaxBuyCampaing,
					data: Campaing,
					success: function(data) {
						if (data.error)
							_dlg.find('.msg').text(data.error);
						else {
							for (var i in KAMPANIEen) {
								var kampania = KAMPANIEen[i];
								if (kampania.id == Campaing.campaingId) {
									kampania.czasRozpoczecia = parseInt(data.czasRozpoczecia);
									kampania.czasZakonczenia = parseInt(data.czasZakonczenia);
									break;
								}
							}
							_dlg.find('.msg').html('Campaign purchased. You can see the invoice ' +
								'<a target="_blank" href="<?php echo Yii::app()->createAbsoluteUrl('/student/main/invoice', array('id'=>'')) ?>/'
								+ data.invoice + '">here</a>.');
						}
						if (data.bankrut)
							bankrutDialogOpen(true);
					},
					complete: enableBts
				});
			},
			buttons: [{text:'OK',click:function(){ $(this).dialog('close'); }}],
			close: function() 
			{
				$(this).parent().remove(); 
				window.location.hash = "agencjaReklamowa"+AGENCJA_ID;
			},
			position: { my: 'center', at: 'center', of: window },
			draggable: true, resizable: false,
			width: 480, height: 320
		});
	}

	// -----

	function showPricingEn()
	{
		var html = '<div class="intARxrPricing" style="background:rgba(255,255,255,0.4)">' +
			'<table><thead><tr><td style="border-right:1px solid black">Type</td><td>Price / day [PLN]</td><td>Price / week [PLN]</td>' +
			'<td>Price / month [PLN]</td></tr></thead><tbody>';
		for (var i in KAMPANIEen)
		{
			var kampania = KAMPANIEen[i];

			var bought = kampania.czasRozpoczecia > 0 && kampania.czasZakonczenia > 0;
			var boughtDay = bought && (kampania.czasZakonczenia - kampania.czasRozpoczecia) <= 60*60*24
			var boughtWeek = bought && !boughtDay && (kampania.czasZakonczenia - kampania.czasRozpoczecia) <= 60*60*24*7
			var boughtMonth = bought && !boughtWeek && (kampania.czasZakonczenia - kampania.czasRozpoczecia) <= 60*60*24*30

			html += '<tr>' +
				'<td style="font-weight:bold;border-right:1px solid black"' + (bought?' class="buyDisabled"':'') + '>' + kampania.nazwa + '<br/>(+ ' +
					kampania.bonus + ' contractor orders)</td>' +
				'<td' + (boughtDay?' class="bought"':'') + '><div>' + (parseFloat(kampania.cenaDzien)+parseFloat(VAT)*parseFloat(kampania.cenaDzien)).toFixed(2) +
					'</div><div>' + (boughtDay?'Active until '+printDate(kampania.czasZakonczenia)+'.':
					'<a class="buy' + (bought?'Disabled':'') + '" period="0" price="' + (parseFloat(kampania.cenaDzien)+parseFloat(VAT)*parseFloat(kampania.cenaDzien)).toFixed(2) + '" campaingId="' + kampania.id + '" href="#">[Select]</a>') + '</div></td>' +
				'<td' + (boughtWeek?' class="bought"':'') + '><div>' + (parseFloat(kampania.cenaTydzien)+parseFloat(VAT)*parseFloat(kampania.cenaTydzien)).toFixed(2) +
					'</div><div>' + (boughtWeek?'Active until '+printDate(kampania.czasZakonczenia)+'.':
					'<a class="buy' + (bought?'Disabled':'') + '" period="1" price="' + (parseFloat(kampania.cenaTydzien)+parseFloat(VAT)*parseFloat(kampania.cenaTydzien)).toFixed(2) + '" campaingId="' + kampania.id + '" href="#">[Select]</a>') + '</div></td>' +
				'<td' + (boughtMonth?' class="bought"':'') + '><div>' + (parseFloat(kampania.cenaMiesiac)+parseFloat(VAT)*parseFloat(kampania.cenaMiesiac)).toFixed(2) +
					'</div><div>' + (boughtMonth?'Active until '+printDate(kampania.czasZakonczenia)+'.':
					'<a class="buy' + (bought?'Disabled':'') + '" period="2" price="' + (parseFloat(kampania.cenaMiesiac)+parseFloat(VAT)*parseFloat(kampania.cenaMiesiac)).toFixed(2) + '" campaingId="' + kampania.id + '" href="#">[Select]</a>') + '</div></td>' +
			'</tr>';
		}
		html += '</tbody></table></div>';

		var cancel = true;
		$(html).dialog({
			title: 'Pricing',
			modal: true,
			autoOpen: true,
			closeOnEscape: false,
			hide: { effect: 'clip', duration: 500 },
			show: { effect: 'scale', duration: 600 },
			open: function() {
				var _dlg = $(this);
				_dlg.find('.buy').click(function(){
					var _this = $(this);
					enableBts(false);
					askEn('Campaign', 'Are you sure you want to purchase this campaign?', function(){
						cancel = false;
						Campaing.period = _this.attr('period');
						Campaing.campaingId = _this.attr('campaingId');
						Campaing.price = (parseFloat(_this.attr('price'))/(parseFloat(1)+parseFloat(VAT)));
						_dlg.dialog('close');
					}, function(){
						enableBts(true);
					});
					return false;
				});
			},
			close: function() {
				if (cancel)
				{
					Dialogue.current.gotoRoot();
					window.location.hash = "agencjaReklamowa"+AGENCJA_ID;
				}
				else
					Dialogue.current.continueDialog();
				$(this).parent().remove();
			},
			position: {
				my: "center",
				at: "center",
				of: window
			},
			draggable: true,
			resizable: false,
			width: 640,
			height: 480
		});
	}

	// -----

	function showPricing()
	{
		var html = '<div class="intARxrPricing" style="background:rgba(255,255,255,0.4)">' +
			'<table><thead><tr><td style="border-right:1px solid black">Rodzaj</td><td>Cena / dzień [zł]</td><td>Cena / tydzień [zł]</td>' +
			'<td>Cena / miesiąc [zł]</td></tr></thead><tbody>';
		for (var i in KAMPANIE)
		{
			var kampania = KAMPANIE[i];

			var bought = kampania.czasRozpoczecia > 0 && kampania.czasZakonczenia > 0;
			var boughtDay = bought && (kampania.czasZakonczenia - kampania.czasRozpoczecia) <= 60*60*24
			var boughtWeek = bought && !boughtDay && (kampania.czasZakonczenia - kampania.czasRozpoczecia) <= 60*60*24*7
			var boughtMonth = bought && !boughtWeek && (kampania.czasZakonczenia - kampania.czasRozpoczecia) <= 60*60*24*30

			html += '<tr>' +
				'<td style="font-weight:bold;border-right:1px solid black"' + (bought?' class="buyDisabled"':'') + '>' + kampania.nazwa + '<br/>(+ ' +
					kampania.bonus + ' zleceń u kontrahentów)</td>' +
				'<td' + (boughtDay?' class="bought"':'') + '><div>' + (parseFloat(kampania.cenaDzien)+parseFloat(VAT)*parseFloat(kampania.cenaDzien)).toFixed(2) +
					'</div><div>' + (boughtDay?'Wykupiono do '+printDate(kampania.czasZakonczenia)+'.':
					'<a class="buy' + (bought?'Disabled':'') + '" period="0" price="' + (parseFloat(kampania.cenaDzien)+parseFloat(VAT)*parseFloat(kampania.cenaDzien)).toFixed(2) + '" campaingId="' + kampania.id + '" href="#">[Wybierz]</a>') + '</div></td>' +
				'<td' + (boughtWeek?' class="bought"':'') + '><div>' + (parseFloat(kampania.cenaTydzien)+parseFloat(VAT)*parseFloat(kampania.cenaTydzien)).toFixed(2) +
					'</div><div>' + (boughtWeek?'Wykupiono do '+printDate(kampania.czasZakonczenia)+'.':
					'<a class="buy' + (bought?'Disabled':'') + '" period="1" price="' + (parseFloat(kampania.cenaTydzien)+parseFloat(VAT)*parseFloat(kampania.cenaTydzien)).toFixed(2) + '" campaingId="' + kampania.id + '" href="#">[Wybierz]</a>') + '</div></td>' +
				'<td' + (boughtMonth?' class="bought"':'') + '><div>' + (parseFloat(kampania.cenaMiesiac)+parseFloat(VAT)*parseFloat(kampania.cenaMiesiac)).toFixed(2) +
					'</div><div>' + (boughtMonth?'Wykupiono do '+printDate(kampania.czasZakonczenia)+'.':
					'<a class="buy' + (bought?'Disabled':'') + '" period="2" price="' + (parseFloat(kampania.cenaMiesiac)+parseFloat(VAT)*parseFloat(kampania.cenaMiesiac)).toFixed(2) + '" campaingId="' + kampania.id + '" href="#">[Wybierz]</a>') + '</div></td>' +
			'</tr>';
		}
		html += '</tbody></table></div>';

		var cancel = true;
		$(html).dialog({
			title: 'Cennik',
			modal: true,
			autoOpen: true,
			closeOnEscape: false,
			hide: { effect: 'clip', duration: 500 },
			show: { effect: 'scale', duration: 600 },
			open: function() {
				var _dlg = $(this);
				_dlg.find('.buy').click(function(){
					var _this = $(this);
					enableBts(false);
					ask('Wykup kampanię', 'Czy chcesz wykupić kampanię?', function(){
						cancel = false;
						Campaing.period = _this.attr('period');
						Campaing.campaingId = _this.attr('campaingId');
						Campaing.price = (parseFloat(_this.attr('price'))/(parseFloat(1)+parseFloat(VAT)));
						_dlg.dialog('close');
					}, function(){
						enableBts(true);
					});
					return false;
				});
			},
			close: function() {
				if (cancel)
				{
					Dialogue.current.gotoRoot();
					window.location.hash = "agencjaReklamowa"+AGENCJA_ID;
				}
				else
					Dialogue.current.continueDialog();
				$(this).parent().remove();
			},
			position: {
				my: "center",
				at: "center",
				of: window
			},
			draggable: true,
			resizable: false,
			width: 640,
			height: 480
		});
	}

	function negotiatePrice()
	{
		$('<div class="dontShowClose"><table style="width:100%;height:calc(100% - 25px)"><tr><td style="text-align: center;">'
			+ '<div style="margin-bottom:25px;font-weight:bold;">Wprowadź cenę:</div><div><input type="text"'
			+ 'id="intAPPNewPrice" value="' + (parseFloat(Campaing.price)+parseFloat(VAT)*parseFloat(Campaing.price)).toFixed(2) + '"/> zł</div></td></tr></table></div>').dialog(
		{
			title: 'Zniżka',
			modal: true,
			autoOpen: true,
			closeOnEscape: false,
			dialogClass: 'dontShowClose',
			hide: { effect: 'clip', duration: 500 },
			show: { effect: 'scale', duration: 600 },
			buttons: [{
				text: 'OK',
				click: function() {
					var max = Math.round(Campaing.price - MAX_DISCOUNT * Campaing.price);
					var price = Math.abs( (parseFloat($('#intAPPNewPrice').val())/(parseFloat(1)+parseFloat(VAT))) );
					if (price > Campaing.price) price = Campaing.price;
					Campaing.price = price > max ? price : max;
					$(this).dialog('close');
				}
			}],
			close: function() {
				Dialogue.current.continueDialog();
				$(this).parent().remove();
			},
			position: {
				my: "center",
				at: "center",
				of: window
			},
			draggable: true,
			resizable: false,
			width: 480,
			height: 320
		});
	}
	
	function negotiatePriceEn()
	{
		$('<div class="dontShowClose"><table style="width:100%;height:calc(100% - 25px)"><tr><td style="text-align: center;">'
			+ '<div style="margin-bottom:25px;font-weight:bold;">Name your price:</div><div><input type="text"'
			+ 'id="intAPPNewPrice" value="' + (parseFloat(Campaing.price)+parseFloat(VAT)*parseFloat(Campaing.price)).toFixed(2) + '"/> PLN</div></td></tr></table></div>').dialog(
		{
			title: 'Discount',
			modal: true,
			autoOpen: true,
			closeOnEscape: false,
			dialogClass: 'dontShowClose',
			hide: { effect: 'clip', duration: 500 },
			show: { effect: 'scale', duration: 600 },
			buttons: [{
				text: 'OK',
				click: function() {
					var max = Math.round(Campaing.price - MAX_DISCOUNT * Campaing.price);
					var price = Math.abs( (parseFloat($('#intAPPNewPrice').val())/(parseFloat(1)+parseFloat(VAT))) );
					if (price > Campaing.price) price = Campaing.price;
					Campaing.price = price > max ? price : max;
					$(this).dialog('close');
				}
			}],
			close: function() {
				Dialogue.current.continueDialog();
				$(this).parent().remove();
			},
			position: {
				my: "center",
				at: "center",
				of: window
			},
			draggable: true,
			resizable: false,
			width: 480,
			height: 320
		});
	}

	// -----
	$(document).on('negotiatePriceEn.przedsiebiorcaDialogueEvents', negotiatePriceEn);

	$(document).on('cennikEn.przedsiebiorcaDialogueEvents', showPricingEn);

	$(document).on('buyDiscountCampaingEn.przedsiebiorcaDialogueEvents', function(){
		Campaing.discount = 1;
		buyCampaingEn();
	});

	$(document).on('buyCampaingEn.przedsiebiorcaDialogueEvents', function(){
		Campaing.discount = 0;
		buyCampaingEn();
	});

	// -----

	$(document).on('negotiatePrice.przedsiebiorcaDialogueEvents', negotiatePrice);

	$(document).on('cennik.przedsiebiorcaDialogueEvents', showPricing);

	$(document).on('buyDiscountCampaing.przedsiebiorcaDialogueEvents', function(){
		Campaing.discount = 1;
		buyCampaing();
	});

	$(document).on('buyCampaing.przedsiebiorcaDialogueEvents', function(){
		Campaing.discount = 0;
		buyCampaing();
	});

	$(document).on('getDialogueParam.przedsiebiorcaDialogueEvents', function(event, key){
		if (key === 'cena')
			return (parseFloat(Campaing.price)+parseFloat(VAT)*parseFloat(Campaing.price)).toFixed(2);
	});

})();
</script>

